  // chrome.browserAction.onClicked.addListener(function() {
  //   chrome.tabs.create({url: 'index.html'});
  // });
  //google drive api key: AIzaSyDTXuAs37WdefrVp2ik8LtLheTC2m6B6Xg
let drive

async function getJSON(file_id) {
	console.log('getJSON')
    return new Promise(function (resolve, reject) {
        gapi.client.request({
            'path': '/drive/v3/files/' + file_id,
            'method': 'GET',
            'params': {
                alt: 'media'
            }
        }).execute(response => {
        	console.log('getJSONresponse',response)
        	//add better error handling for undefined
        	if(!response || response.error)reject(response)
        	else resolve(response)
        })
    })
}


async function listFiles() {
    return new Promise(function (resolve, reject) {
        gapi.client.request({
            'path': '/drive/v3/files',
            'method': 'GET',
            'params': {
                spaces: 'appDataFolder'
            }
        }).execute(response => response.error ? reject(response) : resolve(response))
    })
};

async function saveJSON(fileName,jsonData) {
	if (!fileName)console.error('attempted to save JSON without file name:',jsonData)
		console.log('saveJSON',jsonData)
    return new Promise(function (resolve, reject) {
        gapi.client.request({
            'path': '/drive/v3/files',
            'method': 'POST',
            'headers': {
                'Content-Type': 'application/json'
            },
            'body': {
                'name': fileName,
                'mimeType': 'application/json',
                'parents': ['appDataFolder']
            }
        }).execute(function (response) {
 		console.log('saveJSONresponse',response)
       	
            if (!response.error) {
                gapi.client.request({
                    'path': '/upload/drive/v3/files/' + response.id,
                    'method': 'PATCH',
                    'body': jsonData
                }).execute(function (response) {
			 		console.log('saveJSONresponsePATCHresponse',response)
                    if (!response.error) {
                      //drive.id=response.id
                      resolve(response);
                    } 
                    else {
                      reject(response.error);
                    }
                })
            } 
            else {
                reject(response.error);
            }
        });
    })
}

async function updateJSON(id,jsonData){
	console.log('updateJSON',jsonData)
    return new Promise(function(resolve,reject){
       gapi.client.request({
            'path': '/upload/drive/v3/files/' + id,
            'method': 'PATCH',
            'body': jsonData
        }).execute(response => response.error ? reject(response.error) : resolve(response))
    })
}

async function deleteFile(file_id){
    return new Promise(function (resolve, reject) {
        if (file_id) {
            gapi.client.request({
                'path': '/drive/v3/files/' + file_id,
                'method': 'DELETE'
            }).execute(response => response.error ? reject(response.error) : resolve(response))
        } 
        else {
            reject(new Error('File not found'));
        }
    })
}

async function setToken() {
    return new Promise(function (resolve, reject) {
        // check if Sync library is loaded
        chrome.identity.getAuthToken({interactive: true},function(token){
            if (gapi.load) {
                // init gapi libraries that we need
                gapi.load('client:auth2', function () {
                    // assign access token for requests
                    gapi.client.setToken({access_token: token});
                    resolve({gapi,token});
                    console.log('Token loaded')
                })
            }
        })        
    })
}

let synced=false;
let isOn=false;
chrome.browserAction.setIcon({path: "img/eC-32x32-gray.png"});
let activeTabs=[],currentCommentSet

chrome.runtime.onMessage.addListener(async function(message, sender, sendResponse) {
	switch (message.data){
		// case 'requestSync':
		// 	//synced=true
		// 	chrome.runtime.sendMessage({data: "hello"}, function(response) {
		// 	});
		// 	break;
		case 'checkIfIsOn':
			//synced=true
			if (message.fromPopup){
				// try{
				// 	await setToken()
				// 	await listFiles()
				// 	chrome.runtime.sendMessage({data: "isOn",value:isOn,isSynced:true});
				// }
				// catch(e){
				// }
					chrome.runtime.sendMessage({data: "isOn",value:isOn,isSynced:false});
			}
			else{
				sendResponse({data: "isOn",value:isOn,isSynced:false});
				if (!activeTabs.includes(sender.tab.id)) activeTabs.push(sender.tab.id)
				if (!currentCommentSet)currentCommentSet=message.currentCommentSet
			}
			break;
		case 'turnOn':
		    chrome.browserAction.setIcon({path: "img/eC-16x16.png"});
			isOn=true
			chrome.runtime.sendMessage({data: "isOn",value:isOn});
			break;
		case 'turnOff':
			isOn=false
			chrome.browserAction.setIcon({path: "img/eC-16x16-gray.png"});
			chrome.runtime.sendMessage({data: "isOn",value:isOn});
			break;
		case 'openAVcomment':
			let height= message.type=='video'?500:200
			chrome.windows.create({
				url: 'AVComment.html?type='+message.type+
				'&tabId='+sender.tab.id+'&categoryId='+message.categoryId,
				type:'popup',width: 435, height, left: 600, top: 200
			});
			//console.log('synced ',synced,'isOn ',isOn)
			break;
		case 'openTroubleshooting':
			chrome.tabs.create({url: 'troubleshooting.html'});
			break;
		case 'newTabOpened':
			if (!activeTabs.includes(sender.tab.id)) activeTabs.push(sender.tab.id)
			InitialSync(sender.tab.id)
			break;
		case 'postComments':
			syncToGoogleDrive(message.jsonData,sender.tab.id)
			break;
		case 'changeCommentSet':
			console.log('changeCommentSet','newset',message.currentCommentSet)
			currentCommentSet=message.currentCommentSet
			loadNewCommentSet(currentCommentSet,sender.tab.id)
			break;
	}
})


async function loadNewCommentSet(newSet,senderId){
	console.log('load new comment set')
	chrome.storage.local.get('syncStatus',async function(results){
		if(results && results.syncStatus=='syncedToLocal'){//='syncedToLocal','syncedToGoogle','notSynced'
			syncFromLocal(senderId,true)
			return;
		}
		try{
		    let loginResponse = await setToken()
	    	let fileList= await listFiles()
	    	console.log('fileList',fileList)
	    	let settings,commentData
				commentData = fileList.files.find(el => el.name == currentCommentSet)
		    if (!commentData){
		    	//tell content to send comments
		    	console.log('no Comment Data')
		    	chrome.tabs.sendMessage(senderId, {data:'noCommentSetData'},
			    	function(response){
			    		console.log(response)
			    		syncToGoogleDrive(response.jsonData)
			    		chrome.storage.local.set({jsonData:response.jsonData,currentCommentSet,syncStatus:'syncedToGoogle'});
			    		messageAllContentScripts({data:"changeCommentSet",jsonData:response.jsonData,currentCommentSet})
			    	}
		    	);
		    }
		    else{
			    let jsonData = await getJSON(commentData.id)
		    	console.log('has comment Data already',jsonData)
			    //syncToGoogleDrive(jsonData)
			    chrome.storage.local.set({jsonData,currentCommentSet,syncStatus:'syncedToGoogle'});
			    messageAllContentScripts({data:"changeCommentSet",jsonData,currentCommentSet})
		    }
		}
		catch(e){
			console.log('InitialSync error, syncFromLocal',e)
			syncFromLocal(senderId,true)
		}
	})
}

async function InitialSync(senderId){
	console.log('InitialSync - should only run once per tab')
	chrome.storage.local.get('syncStatus',async function(results){
		if(results && results.syncStatus=='syncedToLocal'){//='syncedToLocal','syncedToGoogle','notSynced'
			syncFromLocal(senderId)
			return;
		}
		try{
		    let loginResponse = await setToken()
	    	let fileList= await listFiles()
	    	console.log('fileList',fileList)
	    	let settings,commentData,settingsData
	    	if (!currentCommentSet){
	    		settings=fileList.files.find(el => el.name == 'settings') 		
				if (settings) {
					settingsData = await getJSON(settings.id)
					console.log('already has settings data',settingsData.currentCommentSet)
					currentCommentSet=settingsData.currentCommentSet
					commentData = fileList.files.find(el => el.name == settingsData.currentCommentSet)
				}
	    	}
	    	else commentData = fileList.files.find(el => el.name == currentCommentSet)
		    if(!commentData){
		    	//tell content to send comments
		    	console.log('noInitialData')
		    	chrome.tabs.sendMessage(senderId, 
		    		{data:'noInitialData',
		    		currentCommentSet: (settingsData ?
		    			settingsData.currentCommentSet : undefined)},
			    	function(response){
			    		console.log(response)
			    		currentCommentSet=response.currentCommentSet
			    		syncToGoogleDrive(response.jsonData,senderId)
			    	}
		    	);
		    }
		    else{
		    	console.log('commentData')
			    let jsonData = await getJSON(commentData.id)
	    		console.log(jsonData)
			    chrome.storage.local.set({jsonData,currentCommentSet,syncStatus:'syncedToGoogle'});
			    //messageAllContentScripts({data:"reconnected"})
			    console.log('syncedToGoogle')
				chrome.tabs.sendMessage(senderId, {data:'initialData',currentCommentSet,jsonData});	
		    }
		}
		catch(e){
			console.log('InitialSync error, syncFromLocal',e)
			syncFromLocal(senderId)
		}
	})
}

function syncFromLocal(senderId,requestingNewCommentSet){
	console.log('syncFromLocal')
	chrome.storage.local.get(currentCommentSet, function(results){
		console.log(results)
		let jsonData= results[currentCommentSet]
		if (jsonData){
			console.log('jsonData',jsonData)
			chrome.storage.local.set({syncStatus:'syncedToLocal'});
		    messageAllContentScripts({data:"connectionLost"})
			console.log('syncedToLocal')
			if (requestingNewCommentSet)messageAllContentScripts({data:"changeCommentSet",jsonData,currentCommentSet})
			else chrome.tabs.sendMessage(senderId, jsonData);
			syncToGoogleDrive(jsonData,senderId)
		}
		else{
			console.log('noInitialData requesting initialData from content script')
			let message= requestingNewCommentSet? 'noCommentSetData':'noInitialData'
			console.log(message)
			chrome.tabs.sendMessage(senderId, {data:message},function(response){
				console.log('syncFromLocal response', response)
				if (requestingNewCommentSet)messageAllContentScripts({data:"changeCommentSet",jsonData:response.jsonData,currentCommentSet})
				// syncToGoogleDrive({[currentCommentSet]:response.jsonData},(requestingNewCommentSet? 'none':senderId))
				syncToGoogleDrive(response.jsonData,(requestingNewCommentSet? 'none':senderId))
	    	});
		}
	});
}

async function syncToGoogleDrive(jsonData,senderId){
	console.log('syncToGoogleDrive',jsonData)
	try{
    	let loginResponse = await setToken()
	    let fileList= await listFiles()
    	console.log('fileList',fileList)

	    let commentData = fileList.files.find(el => el.name == currentCommentSet)
	    console.log(commentData)
   	    let settings = fileList.files.find(el => el.name == 'settings')
   	    if (settings) await updateJSON(settings.id,{currentCommentSet})
   	    else await saveJSON('settings',{currentCommentSet})
	    if (commentData) await updateJSON(commentData.id,jsonData)
	    else await saveJSON(currentCommentSet,jsonData)
    	chrome.storage.local.set({[currentCommentSet]:jsonData,currentCommentSet,syncStatus:'syncedToGoogle'});
    	messageAllContentScripts({data:"reconnected"})
    	console.log('syncedToGoogle')
    	messageAllContentScripts({data:"updateComments",jsonData},senderId)
    }
    catch(e){
    	console.log('syncToGoogleDrive error, syncToLocal instead',jsonData)
    	syncToLocal(jsonData,senderId)
    }
}
let syncedWithLocal=[]
function syncToLocal(jsonData,senderId){
	if (!syncedWithLocal.includes(currentCommentSet))syncedWithLocal.push(currentCommentSet)
	console.log('syncToLocal')
	chrome.storage.local.set({[currentCommentSet]:jsonData,syncStatus:'syncedToLocal',currentCommentSet});
    messageAllContentScripts({data:"connectionLost"})
	console.log('syncedToLocal')
	messageAllContentScripts({data:"updateComments",jsonData,currentCommentSet},senderId)
	if (!attemptingToSync) attemptToSyncWithGoogle(jsonData)
}

async function getLocalData(sKey) {
  return new Promise(function(resolve, reject) {
    chrome.storage.local.get(sKey, function(items) {
      if (chrome.runtime.lastError) {
        console.error(chrome.runtime.lastError.message);
        reject(chrome.runtime.lastError.message);
      } else {
        resolve(items[sKey]);
      }
    });
  });
}

let attemptingToSync=undefined,alreadyReSynced=[]
async function attemptToSyncWithGoogle(jsonData){
		console.log('attemptingToSync',attemptingToSync)
		attemptingToSync = setInterval(async function(){
			try{
				messageAllContentScripts({data:"notReconnecting"})
		    	let loginResponse = await setToken()
			    let fileList= await listFiles()
	       	    let settings = fileList.files.find(el => el.name == 'settings')
	   		    if (settings) await updateJSON(settings.id,{currentCommentSet})
		   	    else await saveJSON('settings',{currentCommentSet})
		   	    console.log('syncedWithLocal',syncedWithLocal)
		   		messageAllContentScripts({data:'reconnecting'})
		   	    for(let i=0;i<syncedWithLocal.length;i++){
		   	    	if (alreadyReSynced.includes(i))continue
			    	let results = await getLocalData(syncedWithLocal[i])
			    	console.log('syncing from local','name:',syncedWithLocal[i],'json:')
			    	console.log(results)
			    	let commentData = fileList.files.find(el => el.name == syncedWithLocal[i])
				    if (commentData) await updateJSON(commentData.id,results)
				    else await saveJSON(syncedWithLocal[i],results)
				    console.log('waited for ',i)
					alreadyReSynced.push[i]
		   	    }
		   	    console.log('synced everything?',syncedWithLocal.length,alreadyReSynced.length)
		   		syncedWithLocal=[]
		   		alreadyReSynced=[]
	        	chrome.storage.local.set({syncStatus:'syncedToGoogle'});
			    messageAllContentScripts({data:"reconnected"})
			    messageAllContentScripts({data:'notReconnecting'})
			    clearInterval(attemptingToSync)
				attemptingToSync=undefined
		    }catch(e){
		    	console.log('could not sync')
		    }
		},2000)
}
		//chrome.storage.local.get('middle',function(results){console.log(results.middle)})

function messageAllContentScripts(payload,exclude){
	activeTabs.forEach(tab=>{
		if (tab!=exclude){
			chrome.tabs.sendMessage(tab, payload);
		}
	})
}